/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.lib39.core.api.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReflectionHelper<T> {
    private final Class<T> clazz;
    private final MethodHandles.Lookup lk;

    private ReflectionHelper(Class<T> clazz, MethodHandles.Lookup lk) {
        this.clazz = clazz;
        this.lk = lk;
    }

    public static <T> ReflectionHelper<T> of(MethodHandles.Lookup lk, Class<T> clazz) {
        try {
            return new ReflectionHelper<T>(clazz, MethodHandles.privateLookupIn(clazz, lk));
        }
        catch (IllegalAccessException e) {
            throw (IllegalAccessError)new IllegalAccessError().initCause(e);
        }
    }

    public <V> Supplier<V> obtainStaticGetter(Class<V> type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findStaticGetter(this.clazz, (String)name, type), handle -> ReflectionHelper.rethrowing(() -> handle.invoke()));
    }

    public <V> Consumer<V> obtainStaticSetter(Class<V> type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findStaticSetter(this.clazz, (String)name, type), handle -> ReflectionHelper.rethrowing((T v) -> handle.invoke(v)));
    }

    public <V> Function<T, V> obtainGetter(Class<V> type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findGetter(this.clazz, (String)name, type), handle -> ReflectionHelper.rethrowing((T t) -> handle.invoke(t)));
    }

    public <V> BiConsumer<T, V> obtainSetter(Class<V> type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findSetter(this.clazz, (String)name, type), handle -> ReflectionHelper.rethrowing((T1 t, T2 v) -> handle.invoke(t, v)));
    }

    public <V> MethodHandle obtainStatic(MethodType type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findStatic(this.clazz, (String)name, type), handle -> handle);
    }

    public <V> MethodHandle tryObtainStatic(MethodType type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, true, name -> this.lk.findStatic(this.clazz, (String)name, type), handle -> handle);
    }

    public <V> MethodHandle obtainVirtual(MethodType type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findVirtual(this.clazz, (String)name, type), handle -> handle);
    }

    public <V> MethodHandle tryObtainVirtual(MethodType type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, true, name -> this.lk.findVirtual(this.clazz, (String)name, type), handle -> handle);
    }

    public <V> MethodHandle obtainSpecial(MethodType type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findSpecial(this.clazz, (String)name, type, this.lk.lookupClass()), handle -> handle);
    }

    public <V> MethodHandle tryObtainSpecial(MethodType type, String ... names) {
        return ReflectionHelper.obtain(this.clazz, names, false, name -> this.lk.findSpecial(this.clazz, (String)name, type, this.lk.lookupClass()), handle -> handle);
    }

    private static <T, R> R obtain(Class<?> clazz, String[] names, boolean failureOk, ExceptableFunction<String, MethodHandle> lookup, ExceptableFunction<MethodHandle, R> constructor) {
        try {
            for (String name : names) {
                try {
                    return constructor.apply(lookup.apply(name));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (!failureOk) {
                throw new NoSuchFieldError("Could not find a field by any of the names given in " + clazz + ": " + Arrays.toString(names));
            }
            return null;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static <T> Supplier<T> rethrowing(ExceptableSupplier<T> sup) {
        return () -> {
            try {
                return sup.get();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private static <T> Consumer<T> rethrowing(ExceptableConsumer<T> cons) {
        return t -> {
            try {
                cons.accept(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private static <T1, T2> BiConsumer<T1, T2> rethrowing(ExceptableBiConsumer<T1, T2> cons) {
        return (t1, t2) -> {
            try {
                cons.accept(t1, t2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private static <T, R> Function<T, R> rethrowing(ExceptableFunction<T, R> func) {
        return t -> {
            try {
                return func.apply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private static interface ExceptableFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    private static interface ExceptableSupplier<T> {
        public T get() throws Throwable;
    }

    private static interface ExceptableConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    private static interface ExceptableBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Throwable;
    }
}

